// ######################################################################
//
//  Servo Control File v0.05 Beta
//
//  Released:  13/02/2017    By: Tony Swanwick
//
// ######################################################################
/*
  This code communicates with the Arduino UNO to controls a servo via
  the USB serial interface.
  
  This version includes:
  You can now adjust slide upper and lower limits.
  Tick link active every 500ms
  
*/

// declare libraries
import processing.serial.*;
Serial usbPort;

// declare variables

int angleMode; // 0 = degrees, 1 = microseconds
int comFlag = 0; // =1 if COM serial available
int comListLength = 0;  // number of items in COM connection list
String comName = ""; // serial port COM name
int comPnt = 0; // COM port list pointer
int ctrlMode; // control mode, 0 = slider, 1 = square, 2 = triangle, 3 =sine
int cycles; // waveform counter
String data = "";
int drawFlag = 1; // = 1 to force screen redraw
float zF; // any temp float value
PImage img; // image loaded as background
int index = 0;
int interval = 10; // main loop interval in milliseconds
int JoyX0 = 170; // x-coordinate of joystick slider left end
int JoyX1 = 630; // x-coordinate of joystick slider right end
int JoyXval; // joystick slider x-value
int keyDwn = 0; // tracks keyboard up/down activity, 0 = up, 1 = down
int LF = 10; // ASCII line feed
int mDown,mON,mTO,mX, mY;  // mouse flag and last x,y
String msgCh; // channel message sent to Arduino
String msgCOM = "None"; // COM port name
String msgRx = ""; // message received from Arduino
String msgTx = ""; // message sent to Arduino
int nextMillis = 0; // loop end time in millis
int period; // half period in draw loop units
int phase; // current waveform phase
int pingON = 1; // > 1 sends regular '~' pings
int qPhase; // quiver phase, 0 or 1
int quiverFlag; // Quiver mode 0 = OFF, 1 = ON
int qVal; // applied quiver offset
int refreshFlag = 1; // = 1 at end of sweep to redraw background
int servoMin, servoMax; // limit constants for servo values
int servoMMD; // limit difference constant for servo values
int servoPin; // pin number used by Arduino
int servoLast = 0; // previous value sent to servo
int servoSwp; // servo sweep flag; default = 0  OFF, 1 = ON
int servoVal; // servo value for manual setting
int servoVLL; // servo value LL for manual setting
int servoVUL; // servo value UL for manual setting
int sliderDwn; // =1 when mouse is clicked on slider
int TB = 0;  // text Blue colour component
int TG = 0;  // text Green colour component
int tick = 0; // tick link send counter
int timeCnt; // wave count down timer
int TMC; // 50ms timer
int TR = 0;  // text Red colour component
int upDwnFlg = 0; // up/down state flag, 0 = down, 1 = up

void setup() {
  // first code to run
  mON = 0; // mouse X,Y is OFF initially
  resetFlags();
  size(800,408);  // screen size must match background bitmap
  loadScrn(0); // load the default screen
  getCOMPort();
  // allow Arduino time to boot up
  delay(100);
  centreJoyX();
  println("Ready!");
}

void draw() {
  // main loop. Comes here about 100 times a second
  TMC--; if (TMC < 1) {
    // do this every 3 loop counts, 33 Hz
    TMC = 2;
    // perform mode actions
    switch(ctrlMode) {
      case 0:
        // slider mode, check for quiver
        if (quiverFlag > 0) {doQuiver();}
        else if (quiverFlag < 0) {setQuiverOFF();}
        break;
      case 1: doSquare(); break;
      case 2: doTriangle(); break;
      case 3: doSine(); break;
      case 4: doSwing(); break;
    }
  }
  if (mDown > 0) {mTO--; if (mTO < 1) {mouseRepeat(); mTO = 4;}}
  if (mON > 0) {drawMouseXY();}
  if (drawFlag > 0) {
    background(img); // define background RGB colour
    drawChMsg(); drawServoVal(); drawLamps();
    drawLLMsg(); drawULMsg(); drawJoyX();
    drawCOMMsg(); drawRxMsg(); drawTxMsg();
    drawFreq(); drawCycles();
    drawFlag = 0;
  }
  // now wait for end of 10ms loop time
  while (millis() < nextMillis) {
    // wait for remainder of 10ms period to sync overall period
  } nextMillis = millis() + interval;
  if (pingON > 0) {
    tick--; if (tick < 1) {
      tick = 50; // reset tick period to 500ms
      usbPortWrite("~"); // send a tick
    }
  }
}

// ----------------------------------------------------------------------

void keyPressed() {
  // used to receive keyboard keys
  keyDwn = 1;
}

// ----------------------------------------------------------------------

void keyReleased() {
  keyDwn = 0;
}

// ----------------------------------------------------------------------

void mouseDragged() {
  // mouse has been clicked and dragged on window
  mX = mouseX; mY = mouseY;
  if (sliderDwn > 0) {
    // ignore mY if it goes outside of slider region
    if ((mX >=150) && (mX <=650)) {
      // mouse in X-slider region
      readXSlider();
    }
  }
}

// ----------------------------------------------------------------------

void mouseMoved() {
  // called whenever the mouse moves
  mX = mouseX; mY = mouseY;
}

// ----------------------------------------------------------------------

void mousePressed() {
  // mouse has been clicked on window
//  mX = mouseX; mY = mouseY;
  mDown = 1; mTO = 30;
  if ((mX < 26) && (mY < 26)) {toggleMouseON();}
  // pin number region?
  if ((mX > 198) && (mX < 552) && (mY > 63) && (mY < 144)) {sendPin();}
  // angle mode buttons
  if ((mX > 575) && (mX < 664)) {
    if ((mY > 63) && (mY < 104)) {setAngleMode(0);}
    if ((mY > 103) && (mY < 144)) {setAngleMode(1);}
  }
  // ping button
  if ((mX > 672) && (mX <760) && (mY > 103) && (mY < 144)) {togglePing();}
  // slider region?
  if ((mX >=136) && (mX <155) && (mY >= 162) && (mY <= 196)) {decXSlider();}
  if ((mX >645) && (mX <=663) && (mY >= 162) && (mY <= 196)) {incXSlider();}
  if ((mX >=155) && (mX <=645) && (mY >= 162) && (mY <= 196)) {
    // mouse in X-slider region
    sliderDwn = 1; readXSlider();
  }
  if ((mY > 163) && (mY < 195)) {
    // adjust slider upper and lower limits
    if ((mX > 34) && (mX < 52)) {setLLValDwn();}
    if ((mX > 112) && (mX < 129)) {setLLValUp();}
    if ((mX > 669) && (mX < 686)) {setULValDwn();}
    if ((mX > 749) && (mX < 764)) {setULValUp();}
  }
  if ((mY > 167) && (mY <= 190)) {
    // store upper and lower limits
    if ((mX >= 53) && (mX <= 112)) {setLL();}
    if ((mX >= 686) && (mX <= 746)) {setUL();}
  }
  if ((mX > 34) && (mX < 115) && (mY > 62) && (mY < 144)) {sendRESET();}
  if ((mX > 384) && (mX < 415) && (mY > 198) && (mY < 222)) {centreServo();}
  if ((mX > 88) && (mX < 176) && (mY > 231) && (mY < 256)) {getCOMPort();}
  // mode buttons
  if ((mY > 277) && (mY < 375)) {
    if ((mX > 34) && (mX < 133)) {setMode(0);}
    if ((mX > 135) && (mX < 233)) {setQuiver();}
    if ((mX > 235) && (mX < 334)) {setMode(1);}
    if ((mX > 336) && (mX < 435)) {setMode(2);}
    if ((mX > 437) && (mX < 536)) {setMode(3);}
    if ((mX > 537) && (mX < 636)) {setMode(4);}
  }
  // check period buttons
  if ((mY > 295) && (mY < 328)) {
    if ((mX > 669) && (mX < 686)) {decPeriod();}
    if ((mX > 685) && (mX < 748)) {period = 20; drawFlag = 1;}
    if ((mX > 747) && (mX < 764)) {incPeriod();}
  }
  if ((mX > 669) && (mX < 764) && (mY > 333) && (mY < 359)) {cycles = 0; drawFlag = 0;}
}

// ----------------------------------------------------------------------

void mouseReleased() {
  // mouse released from click and drag operation
  mX = mouseX; mY = mouseY;
  mDown = 0;
  sliderDwn = 0; // clear slider flag
}

// ----------------------------------------------------------------------

void mouseRepeat() {
  // called if mouse still down after a pause period
  mX = mouseX; mY = mouseY;
  if (sliderDwn < 1) {
    if ((mX >=136) && (mX <155) && (mY >= 162) && (mY <= 196)) {decXSlider();}
    if ((mX >645) && (mX <=663) && (mY >= 162) && (mY <= 196)) {incXSlider();}
    if ((mY > 163) && (mY < 195)) {
      // adjust slider upper and lower limits
      if ((mX > 34) && (mX < 52)) {setLLValDwn();}
      if ((mX > 112) && (mX < 129)) {setLLValUp();}
      if ((mX > 669) && (mX < 686)) {setULValDwn();}
      if ((mX > 749) && (mX < 764)) {setULValUp();}
    }
  }
  // check period buttons
  if ((mY > 295) && (mY < 328)) {
    if ((mX > 669) && (mX < 686)) {decPeriod();}
    if ((mX > 747) && (mX < 764)) {incPeriod();}
  }
}

// ----------------------------------------------------------------------

void serialEvent(Serial usbPort) {
  // respond to a serial data received event
  data = usbPort.readStringUntil(LF);
  msgRx = trim(data); data = "";
  println(msgRx);
  drawFlag = 1;
}
